% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{robustSPM}
\alias{robustSPM}
\title{robustSPM does a robustness test on quality of fit of an SPM}
\usage{
robustSPM(
  inpar,
  fish,
  N = 10,
  scaler = 40,
  verbose = FALSE,
  schaefer = TRUE,
  funk = simpspm,
  funkone = FALSE,
  steptol = 1e-06
)
}
\arguments{
\item{inpar}{the parameter set with which to begin the trials}

\item{fish}{the fisheries data: at least year, catch, and cpue}

\item{N}{number of random trials to run; default = 10 = not enough}

\item{scaler}{the divisor that sets the degree of normal random 
variation to add to the parameter values; default = 15 the 
smaller the value the more variable the outcome}

\item{verbose}{progress and summary statistics to the screen? 
default = FALSE}

\item{schaefer}{default = TRUE, which sets the analysis to the 
Schaefer model. setting it to FALSE applies the approximate Fox model}

\item{funk}{the function used to generate the predicted cpue}

\item{funkone}{defaults=FALSE; use negLL or negLL1, with FALSE 
robustSPM will use negLL, with TRUE it will use negLL1
which has a constraint on the first parameter to keep it > 0}

\item{steptol}{is the steptol from nlm as used in fitSPM, the 
default value is 1e-06, as usual.}
}
\value{
a list containing the results from each run, the range of values 
    across runs, and the median values.
}
\description{
robustSPM conducts a robustness test on the quality of 
    fit of an SPM. This is done by using the original optimal model 
    parameters or the original guessed parameter values, add random 
    variation to each of them, and re-fit the model. This process 
    needs to be repeated multiple times. This should enable an 
    analysis of the stability of the modelling outcomes. If the 
    optimum parameters are used then add more variation, if initial 
    guesses are used you may need to select different starting 
    points so that the random variation covers the parameter space 
    reasonably well.
}
\examples{
  data(dataspm)
  param <- log(c(r=0.24,K=5174,Binit=2846,sigma=0.164))
  ans <- fitSPM(pars=param,fish=dataspm,schaefer=TRUE,maxiter=1000)
  out <- robustSPM(ans$estimate,dataspm,N=5,scaler=40,verbose=TRUE,
                   schaefer=TRUE) # N should be 50, 100, or more
  str(out)
  print(out$results)
  pairs(out$results[,c(6:8,11)]) # need a larger N!
}
