% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRFcov_spatial.R
\name{MRFcov_spatial}
\alias{MRFcov_spatial}
\title{Spatially structured Markov Random Fields with covariates}
\usage{
MRFcov_spatial(
  data,
  symmetrise,
  prep_covariates,
  n_nodes,
  n_cores,
  n_covariates,
  family,
  coords,
  prep_splines = TRUE,
  bootstrap = FALSE,
  progress_bar = FALSE
)
}
\arguments{
\item{data}{A \code{dataframe}. The input data where the \code{n_nodes}
left-most variables are variables that are to be represented by nodes in the graph}

\item{symmetrise}{The method to use for symmetrising corresponding parameter estimates
(which are taken from separate regressions). Options are \code{min} (take the coefficient with the
smallest absolute value), \code{max} (take the coefficient with the largest absolute value)
or \code{mean} (take the mean of the two coefficients). Default is \code{mean}}

\item{prep_covariates}{Logical. If \code{TRUE}, covariate columns will be cross-multiplied
with nodes to prep the dataset for MRF models. Note this is only useful when additional
covariates are provided. Therefore, if \code{n_nodes < NCOL(data)},
default is \code{TRUE}. Otherwise, default is \code{FALSE}. See
\code{\link{prep_MRF_covariates}} for more information}

\item{n_nodes}{Positive integer. The index of the last column in \code{data}
which is represented by a node in the final graph. Columns with index
greater than n_nodes are taken as covariates. Default is the number of
columns in \code{data}, corresponding to no additional covariates}

\item{n_cores}{Positive integer. The number of cores to spread the job across using
\code{\link[parallel]{makePSOCKcluster}}. Default is 1 (no parallelisation)}

\item{n_covariates}{Positive integer. The number of covariates in \code{data}, before cross-multiplication.
Default is \code{NCOL(data) - n_nodes}}

\item{family}{The response type. Responses can be quantitative continuous (\code{family = "gaussian"}),
non-negative counts (\code{family = "poisson"}) or binomial 1s and 0s (\code{family = "binomial"}).
If using (\code{family = "binomial"}), please note that if nodes occur in less than 5 percent
of observations this can make it generally difficult to
estimate occurrence probabilities (on the extreme end, this can result in intercept-only
models being fitted for the nodes in question). The function will issue a warning in this case.
If nodes occur in more than 95 percent of observations, this will return an error as the cross-validation
step will generally be unable to proceed. For \code{family = 'poisson'} models, all returned
coefficients are estimated on the identity scale AFTER using a nonparanormal transformation.
See \code{vignette("Gaussian_Poisson_CRFs")} for details of interpretation}

\item{coords}{A two-column \code{dataframe} (with \code{nrow(coords) == nrow(data)})
representing the spatial coordinates of each observation in \code{data}. Ideally, these
coordinates will represent Latitude and Longitude GPS points for each observation. The coordinates
are used to create smoothed Gaussian Process spatial regression splines via
\code{\link[mgcv]{smooth.construct2}}.
Here, the basis dimension of the smoothed term
is chosen based on the number of unique GPS coordinates in \code{coords}.
If this number is less than \code{100}, then this number is used. If the number of
unique coordiantes is more than \code{100}, a value of \code{100} is used
(this parameter needs to be large in order to ensure enough degrees of freedom
for estimating 'wiggliness' of the smooth term; see
\code{\link[mgcv]{choose.k}} for details).
These splines will be included in each node-wise regression as additional penalized covariates.
This ensures that resulting node interaction parameters are estimated after accounting for
possible spatial autocorrelation. Note that interpretation of spatial autocorrelation is difficult,
and so it is recommended to compare predictive capacities spatial and non-spatial CRFs through
the \code{\link{predict_MRF}} function}

\item{prep_splines}{Logical. If spatial splines are already included in  \code{data}, set to
\code{FALSE}. Default is \code{TRUE}}

\item{bootstrap}{Logical. Used by \code{\link{bootstrap_MRF}} to reduce memory usage}

\item{progress_bar}{Logical. Progress bar in pbapply is used if \code{TRUE}, but this slows estimation.}
}
\value{
A \code{list} of all elements contained in a returned \code{\link{MRFcov}} object, with
the inclusion of a \code{dataframe} called \code{mrf_data}. This contains all prepped covariates
including the added spatial regression
splines, and should be used as \code{data} when generating predictions
via \code{\link{predict_MRF}} or \code{\link{predict_MRFnetworks}}
}
\description{
This function calls the \code{\link{MRFcov}} function to fit
separate penalized regressions for each node and approximate parameters of
Markov Random Fields (MRF) graphs. Supplied GPS coordinates are used to
account for spatial autocorrelation via Gaussian Process spatial regression
splines.
}
\examples{
\donttest{
data("Bird.parasites")
Latitude <- sample(seq(120, 140, length.out = 100), nrow(Bird.parasites), TRUE)
Longitude <- sample(seq(-19, -22, length.out = 100), nrow(Bird.parasites), TRUE)
coords <- data.frame(Latitude = Latitude, Longitude = Longitude)
CRFmod_spatial <- MRFcov_spatial(data = Bird.parasites, n_nodes = 4,
                                family = 'binomial', coords = coords)}

}
\references{
Kammann, E. E. and M.P. Wand (2003) Geoadditive Models.
Applied Statistics 52(1):1-18.
}
\seealso{
See \code{\link[mgcv]{smooth.construct2}} and \code{\link[mgcv]{smooth.construct.gp.smooth.spec}}
for details of Gaussian process spatial regression splines. Worked examples to showcase
this function can be found using \code{vignette("Bird_Parasite_CRF")}
}
