% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrstdlcrt.R
\name{mrstdlcrt_fit}
\alias{mrstdlcrt_fit}
\title{Fit model-robust standardization for longitudinal CRTs}
\usage{
mrstdlcrt_fit(
  data,
  formula,
  cluster_id = "cluster",
  period = "period",
  trt = "trt",
  method = c("gee", "lmer", "glmer"),
  family = c("gaussian", "binomial"),
  corstr = "independence",
  scale = c("RD", "RR", "OR")
)
}
\arguments{
\item{data}{data.frame with outcome, treatment, period, cluster, covariates.}

\item{formula}{model formula; may include interactions and random effects.}

\item{cluster_id}{cluster id column name.}

\item{period}{period column name.}

\item{trt}{treatment column name (0/1).}

\item{method}{"gee","lmer","glmer".}

\item{family}{"gaussian","binomial".}

\item{corstr}{gee correlation.}

\item{scale}{For binomial: "RD","RR","OR" (RR/OR are on log scale).}
}
\value{
Object of class "mrs".
}
\description{
Fit model-robust standardization for longitudinal CRTs
}
