% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{phiX_c}
\alias{phiX_c}
\title{The Function to Calculate the phiX Matrix for Estimating Single-Index Function}
\usage{
phiX_c(Xbeta, u, L)
}
\arguments{
\item{Xbeta}{The single index values. A vector of length n.}

\item{u}{The vector spanning from -1 to 1 with length L + 1.}

\item{L}{An integer defining the number of nodes.}
}
\value{
A n by L + 1 matrix.
}
\description{
The function \verb{phiX_c} is used to generate the phiX matrix associated with the Gaussian process prior.
}
\examples{
L <- 50
u <- seq(-1,1,length.out = L + 1)
phiX <- phiX_c(0.5,u,L)
print(phiX)
}
