% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_part1_cov.r
\name{model_configuration2}
\alias{model_configuration2}
\title{model_configuration2 function}
\usage{
model_configuration2(
  data_train,
  data_valid,
  mv,
  cov_train,
  cov_valid,
  model = "lm"
)
}
\arguments{
\item{data_train}{This includes the dataframe of the training dataset in a matrix format}

\item{data_valid}{This includes the dataframe of the validation dataset in a matrix format}

\item{mv}{The total number of columns in data_train/data_valid}

\item{cov_train}{This includes dataframe of covariates for training dataset in a matrix format}

\item{cov_valid}{This includes dataframe of covariates for validation dataset in a matrix format}

\item{model}{This is the type of model (e.g. lm (default) or glm (logistic regression))}
}
\value{
This function will generate all possible model outcomes for validation and test dataset
}
\description{
This function is similar to the model_configuration function,
with the added capability to maintain constant variables across models
during training and prediction (see cov_train and cov_valid in page 2).
Additionally, users have the option to select between linear or logistic regression models.
}
\examples{
\donttest{
data_train <- data_train
data_valid  <- data_valid
mv=8
cov_train <- cov_train
cov_valid  <- cov_valid
out=model_configuration2(data_train,data_valid,mv,cov_train, cov_valid, model = "lm")
#This process will produce predicted values for the validation datasets,
#corresponding to each model configuration trained on the training dataset.
#The outcome of this function will yield variables named 'predict_validation'
#and 'total_model_configurations.
#To print the outcomes run out$predict_validation and out$total_model_configurations.
#For details (see https://github.com/mommy003/MSML). 
}
#If a user intends to employ logistic regression without constant covariates, 
#we advise preparing a covariate file where all values are set to 1.
}
\keyword{All}
\keyword{combinations}
\keyword{model}
\keyword{possible}
