% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SignalProcessing.R
\name{SignalProcessing}
\alias{SignalProcessing}
\title{Signal processing for MALDI-TOF spectra (wrapper to SignalProcessingUltra)}
\usage{
SignalProcessing(
  x,
  transformIntensity_method = "sqrt",
  smoothing_method = "Wavelet",
  removeBaseline_method = "SNIP",
  removeBaseline_iterations = 25,
  calibrateIntensity_method = "TIC",
  alignSpectra_NoiseMethod = "MAD",
  alignSpectra_method = "lowess",
  alignSpectra_halfWs = 11,
  alignSpectra_SN = 3,
  tolerance_align = 0.002,
  referenceSpectra = NULL,
  minFrequency = 0.5,
  binPeaks_method = "strict",
  keepReferenceSpectra = FALSE,
  ...
)
}
\arguments{
\item{x}{list of MALDIquant MassSpectrum objects.}

\item{transformIntensity_method}{character, intensity transform (default "log").}

\item{smoothing_method}{character, smoothing method ("Wavelet" UDWT).}

\item{removeBaseline_method}{character, baseline method ("TopHat" default; "SNIP","ConvexHull" supported).}

\item{removeBaseline_iterations}{integer, SNIP iterations if removeBaseline_method = "SNIP".}

\item{calibrateIntensity_method}{character, intensity calibration ("PQN" default, or "TIC","median").}

\item{alignSpectra_NoiseMethod}{character, noise estimator for peak finding pre-alignment ("MAD").}

\item{alignSpectra_method}{character, alignment engine: "cubic" (default), "lowess", or "landmark_cpp".}

\item{alignSpectra_halfWs}{integer, half window size for peak detection.}

\item{alignSpectra_SN}{numeric, SNR for peak detection.}

\item{tolerance_align}{numeric, tolerance for matching anchors to the reference during alignment.
Use consistent units across your pipeline (Da by default here).}

\item{referenceSpectra}{optional MALDIquant MassPeaks object to use as alignment reference.}

\item{minFrequency}{numeric, minimum peak frequency to build reference if not provided (default 0.7).}

\item{binPeaks_method}{character, "strict" (default) or "relaxed" for reference peak binning.}

\item{keepReferenceSpectra}{logical, if TRUE and no reference provided, returns list(spectra=..., RefS=...).}

\item{...}{additional arguments passed to SignalProcessingUltra (e.g., n_workers, ref_sample_n).}
}
\value{
A list of processed MassSpectrum objects, or list(spectra, RefS) if keepReferenceSpectra = TRUE.
}
\description{
Backward-compatible wrapper that delegates to SignalProcessingUltra.
Keeps the original argument names/signature so existing code continues to work.
}
