% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoxMtest.R
\name{boxMtest}
\alias{boxMtest}
\title{Box's M-test}
\usage{
boxMtest(data,
         group)
}
\arguments{
\item{data}{A numeric matrix or data frame.}

\item{group}{In either vector or factor form, the length of the group must correspond to the number of observations \code{n} in the data.}
}
\value{
\item{M.stat}{Box's M-test statistic approximates the chi-square distribution.}
   \item{df}{The degree of freedom is related to the test statistic.}
   \item{p.value}{The p-value of the test statistic.}
}
\description{
Performs Box's M-test for homogeneity of covariance matrices derived from multivariate normality data according to a single classification factor. This test is based on the chi-square approximation.
}
\examples{
data(wine)
class <- wine$class
winedata <- subset(wine, select = -class)
boxMtest(winedata, class)

}
\seealso{
\code{mardiatest}
}
\keyword{BoxM}
