% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{descriptives}
\alias{descriptives}
\title{Descriptive Statistics for Numeric Data}
\usage{
descriptives(data)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame with observations in rows and variables in columns.}
}
\value{
A data frame where each row corresponds to a variable and each column represents a summary statistic:
number of non-missing observations (\code{n}), arithmetic mean (\code{Mean}),
standard deviation (\code{Std.Dev}), median (\code{Median}), minimum (\code{Min}),
maximum (\code{Max}), first quartile (\code{25th}), third quartile (\code{75th}),
sample skewness (\code{Skew}, from \code{moments::skewness}), and sample kurtosis
(\code{Kurtosis}, from \code{moments::kurtosis}).
}
\description{
Computes key descriptive statistics for each numeric variable in a vector, matrix, or data frame.
}
\examples{
\dontrun{
data <- iris[1:4]
descriptives(data)
}

}
