% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2mtch.R
\name{compute_R2HVC}
\alias{compute_R2HVC}
\title{Modified tchebyscheff R2-indicator contribution designed to approximate HV}
\usage{
compute_R2HVC(
  dataPoints,
  reference,
  weights = NULL,
  alpha = 1,
  nWeight = 300,
  indexOfInterest = 1:ncol(dataPoints)
)
}
\arguments{
\item{dataPoints}{The Points coordinate. Each column contains a single point (column major).}

\item{reference}{The reference point for computing R2-mtch (similar as reference for HV)}

\item{weights}{The weights/direction to be used to compute the achievement scalarization. Each column contains a single weight vector. If no weight is supplied, weights are generated using Sobol sequences}

\item{alpha}{Power factor on the gmtch and g*2tch utility functions.}

\item{nWeight}{Used only when no weights are supplied. The number of weights generated by sobol sequence.}

\item{indexOfInterest}{individuals to be evaluated. The R2 values will only be reported/returned for these individuals.}
}
\value{
The function return R2-indicator contribution of each point.
}
\description{
Compute the R2-HVC from Shang et al.
}
\examples{
nPointToSample <- 100
nObjective <- 3
points <- matrix(runif(nPointToSample*nObjective), nrow = nObjective) # sample the points
ranks <- nsga2R::fastNonDominatedSorting(t(points)) # non-dominated sorting
points <- points[,ranks[[1]],drop=FALSE] # take only the non-dominated front
nPoints <- ncol(points) # check how many points are on the non-dominated front
reference <- rep(2,nObjective)

compute_R2HVC(points,reference)
}
\references{
K. Shang, H. Ishibuchi and X. Ni, "R2-based Hypervolume Contribution Approximation," in IEEE Transactions on Evolutionary Computation. doi: 10.1109/TEVC.2019.2909271
}
