% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantextnetwork.r
\name{f5}
\alias{f5}
\title{Filter Data Frame by Document ID}
\usage{
f5(UPIP, I)
}
\arguments{
\item{UPIP}{A data frame with a column named 'doc_id'.}

\item{I}{An integer representing the document ID.}
}
\value{
Returns a subset of the input data frame (`UPIP`) containing only
the rows where the 'doc_id' column matches the specified document ID `I`.
If `I` is 0, the function returns the entire data frame unmodified. The
output is a data frame with the same structure as the input but potentially
fewer rows, depending on the presence and frequency of the specified ID.
}
\description{
This function filters a data frame by the specified document ID.
If the ID is 0, the entire data frame is returned.
}
\examples{
data <- data.frame(doc_id = 1:5, text = letters[1:5])
filtered_data <- f5(data, 2)
}
