% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantext.r
\name{fun.one.sums}
\alias{fun.one.sums}
\title{General Persian Suffix Modification}
\usage{
fun.one.sums(v, type)
}
\arguments{
\item{v}{A character vector of Persian words.}

\item{type}{A character string representing the suffix type.}
}
\value{
Returns a character vector where each element corresponds to a word
from the input vector `v` with the specified suffix type modified.
This results in a transformed vector where each word has been modified
to remove or alter the specified suffix. The length of the returned
vector matches the length of the input vector, and each word is
modified independently based on the specified suffix type.
}
\description{
This function modifies Persian words based on a specified suffix type.
}
\examples{
\dontrun{
  words <- c("Persian text here")
  modified_words <- fun.one.sums(words, "Persian text here")
}
}
