% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{hyperposterior}
\alias{hyperposterior}
\title{Compute the hyper-posterior distribution in Magma}
\usage{
hyperposterior(
  trained_model = NULL,
  data = NULL,
  hp_0 = NULL,
  hp_i = NULL,
  kern_0 = NULL,
  kern_i = NULL,
  prior_mean = NULL,
  grid_inputs = NULL,
  pen_diag = 1e-10
)
}
\arguments{
\item{trained_model}{A list, containing  the information coming from a
Magma model, previously trained using the \code{\link{train_magma}}
function. If \code{trained_model} is not provided, the arguments
\code{data}, \code{hp_0}, \code{hp_i}, \code{kern_0}, and \code{kern_i}
are all required.}

\item{data}{A tibble or data frame. Required columns: 'Input',
'Output'. Additional columns for covariates can be specified.
The 'Input' column should define the variable that is used as
reference for the observations (e.g. time for longitudinal data). The
'Output' column specifies the observed values (the response
variable). The data frame can also provide as many covariates as desired,
with no constraints on the column names. These covariates are additional
inputs (explanatory variables) of the models that are also observed at
each reference 'Input'. Recovered from \code{trained_model} if not
provided.}

\item{hp_0}{A named vector, tibble or data frame of hyper-parameters
associated with \code{kern_0}. Recovered from \code{trained_model} if not
provided.}

\item{hp_i}{A tibble or data frame of hyper-parameters
associated with \code{kern_i}. Recovered from \code{trained_model} if not
provided.}

\item{kern_0}{A kernel function, associated with the mean GP.
Several popular kernels
(see \href{https://www.cs.toronto.edu/~duvenaud/cookbook/}{The Kernel
Cookbook}) are already implemented and can be selected within the
following list:
\itemize{
\item "SE": (default value) the Squared Exponential Kernel (also called
Radial Basis Function or Gaussian kernel),
\item "LIN": the Linear kernel,
\item "PERIO": the Periodic kernel,
\item "RQ": the Rational Quadratic kernel.
Compound kernels can be created as sums or products of the above kernels.
For combining kernels, simply provide a formula as a character string
where elements are separated by whitespaces (e.g. "SE + PERIO"). As the
elements are treated sequentially from the left to the right, the product
operator '*' shall always be used before the '+' operators (e.g.
'SE * LIN + RQ' is valid whereas 'RQ + SE * LIN' is  not). Recovered from
\code{trained_model} if not provided.
}}

\item{kern_i}{A kernel function, associated with the individual GPs. ("SE",
"PERIO" and "RQ" are aso available here). Recovered from
\code{trained_model} if not provided.}

\item{prior_mean}{Hyper-prior mean parameter of the mean GP. This argument,
can be specified under various formats, such as:
\itemize{
\item NULL (default). The hyper-prior mean would be set to 0 everywhere.
\item A number. The hyper-prior mean would be a constant function.
\item A vector of the same length as all the distinct Input values in the
\code{data} argument. This vector would be considered as the evaluation
of the hyper-prior mean function at the training Inputs.
\item A function. This function is defined as the hyper-prior mean.
\item A tibble or data frame. Required columns: Input, Output. The Input
values should include at least the same values as in the \code{data}
argument.
}}

\item{grid_inputs}{A vector or a data frame, indicating the grid of
additional reference inputs on which the mean process' hyper-posterior
should be evaluated.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
A list gathering the parameters of the mean processes'
hyper-posterior distributions, namely:
\itemize{
\item mean: A tibble, the hyper-posterior mean parameter
evaluated at each training \code{Input}.
\item cov: A matrix, the covariance parameter for the
hyper-posterior distribution of the mean process.
\item pred: A tibble, the predicted mean and variance at
\code{Input} for the mean process' hyper-posterior
distribution under a format that allows the direct
visualisation as a GP prediction.
}
}
\description{
Compute the parameters of the hyper-posterior Gaussian distribution of the
mean process in Magma (similarly to the expectation step of the EM
algorithm used for learning). This hyper-posterior distribution, evaluated
on a grid of inputs provided through the \code{grid_inputs} argument, is a
key component for making prediction in Magma, and is required in the function
\code{\link{pred_magma}}.
}
\examples{
TRUE
}
