#' Subtract Two Adjacency Matrices
#'
#' This function returns difference matrix between two networks.
#' It is useful for comparing two networks represented by adjacency matrices.
#'
#' @param matrix1 The first adjacency matrix.
#' @param matrix2 The second adjacency matrix.
#' @return a normalized matrix containing values between 0 and 1.
#' @export
differentiation <- function(matrix1, matrix2) {
  # Normalize matrix1 to the range [0, 1]
  matrix1 <- normalization(matrix1)
  matrix2 <- normalization(matrix2)

  difference_models <- (matrix1) - (matrix2)

  return(difference_models)
}
