% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/US_countyConversion.R
\name{US_countyConversion}
\alias{US_countyConversion}
\alias{US_countyFIPSToName}
\alias{US_countyNameToFIPS}
\title{Conversion functions for US county names and FIPS codes.}
\usage{
US_countyNameToFIPS(state = NULL, countyName = NULL)

US_countyFIPSToName(state = NULL, countyFIPS = NULL)
}
\arguments{
\item{state}{Vector of state codes, names or FIPS codes. Values will be
evaluated to determine the type of input.}

\item{countyName}{Vector of English language county names.}

\item{countyFIPS}{Vector of two-digit FIPS codes.}
}
\value{
A vector of US county names or FIPS codes.
}
\description{
Converts a vector of US county names or FIPS codes from one
system to another returning \code{NA} where no match is found.
}
\examples{
library(MazamaSpatialUtils)

US_countyNameToFIPS("Washington", "King")

# If a single state is provided, it will be recycled
US_countyNameToFIPS("Washington", c("King", "Okanogan"))

# Normally, equal length vectors are provided
US_countyNameToFIPS(c("WA", "WA"), c("King", "Okanogan"))

# You cannot mix codes!
US_countyNameToFIPS(c("WA", "Washington"), c("King", "Okanogan"))

# No 'Okanogan' county in Texas
US_countyNameToFIPS(c("WA", "TX"), c("King", "Okanogan"))

# But there is a 'King' county in Texas
US_countyNameToFIPS(c("TX", "WA"), c("King", "Okanogan"))
US_countyNameToFIPS(c("TX", "WA"), c("King", "King"))

# The US_countyFIPSToName() function is included for symmetry but a
# more typical usage of a 5-digit county FIPS would be to extract it from
# the US_countyCodes package dataset:

US_countyCodes \%>\% dplyr::filter(countyFIPS == 53033)

}
