% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3-dose.R
\name{dose}
\alias{dose}
\alias{print.dose}
\alias{plot.dose}
\title{Print and Plot Methods for Dose-Response Meta-Regression Objects}
\usage{
\method{print}{dose}(x, model = c("both", "linear", "nonlinear"), ...)

\method{plot}{dose}(x, model = c("both", "linear", "nonlinear"), ...)
}
\arguments{
\item{x}{An object of class \code{"dose"} returned by
\code{\link{mdcont}} or \code{\link{mdbin}}.}

\item{model}{Character string specifying which model results to display.
Options are \code{"both"}, \code{"linear"}, or \code{"nonlinear"}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Both methods are called for their side effects.

\itemize{
  \item \code{print.dose} prints model summaries to the console.
  \item \code{plot.dose} draws dose-response plots in the active graphics device.
}

The original object \code{x} is returned invisibly.
}
\description{
S3 methods for objects of class `dose` returned by `mdcont()` and `mdbin()` functions.

\itemize{
  \item \code{print.dose} displays summaries of the fitted linear and/or
  nonlinear dose-response meta-regression models.
  \item \code{plot.dose} visualizes the fitted dose-response curves produced
  by the meta-regression models.
}
}
\seealso{
\code{\link{mdcont}}, \code{\link{mdbin}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
\keyword{methods}
