% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaNLP.R
\name{plot,MetaNLP,missing-method}
\alias{plot,MetaNLP,missing-method}
\title{Create bar plot from MetaNLP-object}
\usage{
\S4method{plot}{MetaNLP,missing}(
  x,
  y = NULL,
  n = 10,
  decision = c("total", "include", "exclude"),
  stop_words = FALSE,
  ...
)
}
\arguments{
\item{x}{A MetaNLP object to plot}

\item{y}{not used}

\item{n}{Number of bars}

\item{decision}{Stratify bar plot by decision. Default is no stratification.}

\item{stop_words}{Boolean to decide whether stop words shall be included in
the summary. \code{stop_words = TRUE} means, that stop words are included.}

\item{...}{Additional parameters for \code{delete_stop_words} (e.g. language
of the stop words).}
}
\value{
nothing
}
\description{
This method creates a bar plot from a MetaNLP object, displaying the most
frequent word stems.
}
\note{
Note that "most frequent" here refers to the entries
of the document-term matrix. If "binary" or "tf-idf" weighting was chosen,
the displayed values are in terms of the weighted entries.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
plt <- plot(obj)

}
