% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{rse}
\alias{rse}
\title{Relative Squared Error}
\usage{
rse(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{rse} computes the relative squared error between two numeric vectors.
}
\details{
\code{rse} divides \code{sse(actual, predicted)} by \code{sse(actual, mean(actual))},
meaning that it provides the squared error of the predictions relative to a naive model that
predicted the mean for every data point.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
rse(actual, predicted)
}
\seealso{
\code{\link{rrse}} \code{\link{rae}}
}
