% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MexBrewer-package.R
\docType{data}
\name{df_mxstate_2020}
\alias{df_mxstate_2020}
\title{Mexican 2020 states dataset}
\format{
An object of class \code{data.frame} with 32 rows and 11 columns.
}
\usage{
df_mxstate_2020
}
\value{
A data.frame
}
\description{
A data.frame containing population estimates for all the Mexican states in 2020
}
\details{
\describe{
\item{region}{INEGI code of the state}
\item{state_name}{short state name (e.g. Coahuila)}
\item{state_name_official}{Official state name (e.g. Coahuila de Zaragoza)}
\item{state_abbr}{state abbreviation}
\item{state_abbr_official}{official state abbreviation (it can be awkward to use Chis for Chiapas)
according to the INEGI.}
\item{year}{2015, the year of the Conteo from which the data is sourced}
\item{pop}{total state population according to the Censo 2020}
\item{pop_male}{male population according to the Censo 2020}
\item{pop_female}{female population according to the Censo 2020}
\item{afromexican}{afromexican population according to the Censo 2020}
\item{indigenous_language}{Number of persons who speak an indigenous language according to the Censo 2020}
}
}
\examples{
data("df_mxstate_2020")
head(df_mxstate_2020)
}
\references{
Population estimates taken from the \href{https://www.inegi.org.mx/programas/ccpv/2020/default.html#Tabulados}{Censo 2020.}
}
\keyword{data}
