% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epf.2011.miembros.R
\name{epf.2011.miembros}
\alias{epf.2011.miembros}
\title{Download data from the Encuesta de Presupuestos Familiares (EPF)}
\usage{
epf.2011.miembros(file)
}
\arguments{
\item{file}{Character string with the name of the microdata file provided by the INE on the
\href{http://www.ine.es/dyngs/INEbase/es/operacion.htm?c=Estadistica_C&cid=1254736176806&menu=resultados&secc=1254736195147&idp=1254735976608}{EPF} section. It allows either a path to a file,
or literal data (single string or raw vector). It also allows compressed files in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} format.}
}
\value{
\code{\link[tibble]{tibble}} with all avaliable requested data where each row corresponds to an anonymised citizen.
}
\description{
This function downloads data from the Spanish Survey of Family Budgets \strong{(Members approach)} using the information provided by the Spanish Statistical Office (INE).
}
\details{
This function reads microdata from the members approach of the Survey of Family Budgets in Spain. It was originally built using the metadata for 2011 file but it may be used for later years. Previous files have a different, non compatible, format.
}
\note{
The \code{file} parameter allows any flat file with fixed width.
}
\examples{
\dontrun{
raw <- epf.2011.gastos("sample_miembros_a2011.txt")
summary(raw)
}
}
\references{
http://www.ine.es/prodyser/microdatos.htm
}
\seealso{
\code{\link[readr]{read_fwf}} to read fixed width files.
}
\author{
Diego Paniagua Sánchez and Carlos J. Gil Bellosta
}
