% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryData.R
\name{SummaryData}
\alias{SummaryData}
\title{This function gives indices such as Observed richness, Shannon index, Inverse Simpson, ... of higher level such as levelily, order, phylum, ...}
\usage{
SummaryData(Micro.mat, info, measure = "observed")
}
\arguments{
\item{Micro.mat}{an OTU matrix with OTUs in rows and subjects in columns.}

\item{info}{A n x 2 matrix containing a column of OTU's names and a column of the corresponding information of the chosen level.}

\item{measure}{The indices at chosen level that user wishes to use. It can be observed richness, Shannon index, inverse Simpson, ...}
}
\value{
A matrix of the selected measurement of the chosen level.
\item{level.measure}{A matrix of measurements at levelily level of patients}
}
\description{
This function gives indices such as Observed richness, Shannon index, Inverse Simpson, ... of higher level such as levelily, order, phylum, ...
}
\examples{
# Read dataset
data(Week3_otu)
Week3_otu = data.frame(Week3_otu)
otu_mat_w3 = t(data.matrix(Week3_otu[ , 1:2720]))
data(fam_info_w3)

# USing the function
fam_shan_w3 = SummaryData(Micro.mat = otu_mat_w3, info = fam_info_w3, measure = "shannon")
}
\seealso{
\code{\link[MicrobiomeSurv]{SummaryData}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
