% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm-class.R
\docType{class}
\name{perm-class}
\alias{perm-class}
\alias{perm}
\alias{show,perm-method}
\alias{summary,perm-method}
\alias{plot,perm,ANY-method}
\alias{perm-method}
\title{The perm Class.}
\usage{
\S4method{show}{perm}(object)

\S4method{summary}{perm}(object)

\S4method{plot}{perm,ANY}(x, y, ...)
}
\arguments{
\item{object}{A perm class object}

\item{x}{A perm class object}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{DistHR}}.
}
\section{Slots}{

\describe{
\item{\code{HRobs}}{Estimated HR for low risk group on the original data.}

\item{\code{HRperm}}{Estimated HR for low risk group on the permuted data.}

\item{\code{nperm}}{Number of permutations carried out.}

\item{\code{Validation}}{The validation scheme that was used.}
}}

\note{
The first, third and last vertical line on the plot are the lower,
median  and upper CI of the permuted data estimated HR while
the red line is the estimated HR of the original data
}
\seealso{
\code{\link[MicrobiomeSurv]{DistHR}}, \code{\link[MicrobiomeSurv]{EstimateHR}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}, \code{\link[MicrobiomeSurv]{Majorityvotes}}, \code{\link[MicrobiomeSurv]{Lasoelascox}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
