% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{mock_gibbs_sampling}
\alias{mock_gibbs_sampling}
\title{Mock Gibbs sampling for alpha-stable mixture estimation}
\usage{
mock_gibbs_sampling(data, n_samples = 500, verbose = FALSE)
}
\arguments{
\item{data}{Numeric vector of observations.}

\item{n_samples}{Number of Gibbs samples to draw.}

\item{verbose}{Logical, whether to print best log-likelihood.}
}
\value{
List containing best_params and all sampled parameter sets.
}
\description{
Performs a simplified Gibbs sampling procedure to estimate parameters of a two-component
alpha-stable mixture. Samples are drawn from prior distributions and evaluated using
log-likelihood. The best parameter set is selected based on likelihood.
}
