% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable_mixture_estimators.R
\name{run_all_estimations}
\alias{run_all_estimations}
\title{Run all EM-based estimations without Gibbs sampling (CRAN-safe)}
\usage{
run_all_estimations(X1, bw_sj, max_iter = 200, tol = 1e-04, save_plots = FALSE)
}
\arguments{
\item{X1}{Numeric vector of data.}

\item{bw_sj}{Numeric. Bandwidth value (e.g., Silverman's rule).}

\item{max_iter}{Integer. Maximum number of EM iterations.}

\item{tol}{Numeric. Convergence tolerance.}

\item{save_plots}{Logical. Whether to save PNG plots to tempdir().}
}
\value{
Invisibly returns a list containing fitted parameters for each EM method.
}
\description{
Executes multiple EM algorithms (recursive ECF, kernel ECF, weighted OLS, CDF-based)
on the input data. Optionally saves mixture plots to a temporary directory.
}
