# Clean environment and load libraries
rm(list = ls())  # Clear environment to avoid conflicts

# Source files
library(MixStable)

set.seed(123)
X <- stabledist::rstable(1000, alpha = 1, beta = 0, 1, 0, pm = 1)
t_grid <- seq(0.1, 1.0, length.out = 50)
phi_vals <- ecf_empirical(X, t_grid)
components <- ecf_components(phi_vals)
y_vals <- components$y_vals
arg_vals <- components$arg_vals
print(y_vals)
print(arg_vals)
