library(MixStable)
# 📊 Generate data
x_vals <- seq(-5, 5, length.out = 100)
data <- rnorm(1000)

# 🧮 Compute PDF
pdf_vals <- r_stable_pdf(x_vals, alpha = 1.5, beta = 0.5, scale = 1, location = 0)
# 📊 Generate 1200 samples from a stable distribution
samples <- rstable(n = 1200, alpha = 1.2, beta = 0.5, gamma = 1, delta = 3, pm = 1)
# 🧮 Estimate initial parameters
params <- stable_fit_init(data)


# 📈 Plot
plot(x_vals, pdf_vals, type = "l", col = "blue", main = "Stable Distribution PDF",
     xlab = "x", ylab = "Density")
# 📋 Display summary
summary(samples)
# 📋 Display
cat(sprintf("alpha: %.3f, beta: %.3f, gamma: %.3f, delta: %.3f\n",
            params$alpha, params$beta, params$gamma, params$delta))
