% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstDepMoebius.R
\name{EstDepMoebius}
\alias{EstDepMoebius}
\title{Dependence measures and statistics for test of independence  between random variables}
\usage{
EstDepMoebius(x, trunc.level = 2, graph = FALSE)
}
\arguments{
\item{x}{Data matrix}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}

\item{graph}{Set to TRUE if one wants the dependogram of P-values for the Moebius statistics}
}
\value{
\item{stat}{List of statistics (spearman, vdw, savage) and test combinations Ln and Ln2 (only pairs)}

\item{pvalue}{P-values for the tests}

\item{cardA}{Cardinaly of the subsets for the Moebius statistics}

\item{subsets}{Subsets for the Moebius statistics}
}
\description{
This function computes copula-based dependence measures for Moebius versions of Spearmans's rho, van der Waerden's coefficient, and Savage's coefficient, as well as their combination for tests of independence between random variables.
}
\examples{
x <- matrix(rnorm(250),ncol=5)
out <-EstDepMoebius(x,3)
}
\references{
B.R Nasri & B.N. Remillard (2023). Tests of independence and randomness for arbitrary data using copula-based covariances
}
