% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.database.R
\name{get.database}
\alias{get.database}
\title{gen/database/cohorts conversion}
\usage{
get.database(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  avoid.merging = FALSE,
  per.individual = FALSE,
  id = NULL,
  db.names = NULL,
  id.all.copy = FALSE,
  id.last = FALSE,
  keep.order = FALSE,
  class = NULL,
  genotyped = NULL,
  npheno = NULL,
  verbose = TRUE,
  sex.filter = 0
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{avoid.merging}{Set to TRUE to avoid different cohorts to be merged in a joint group when possible}

\item{per.individual}{Set TRUE to obtain a database with one row per individual instead of concatenating (default: FALSE)}

\item{id}{Individual IDs to search/collect in the database}

\item{db.names}{MoPBS internal names (SexNr_Generation)}

\item{id.all.copy}{Set to TRUE to show all copies of an individual in the database (default: FALSE)}

\item{id.last}{Set to TRUE to use the last copy of an individual for the database (default: FALSE - pick first copy)}

\item{keep.order}{To not change order of individuals when ids are provided (default: FALSE)}

\item{class}{Only include individuals of the following classes in the database (can also be vector with multiple classes; default: ALL)}

\item{genotyped}{Only include individuals that are genotyped (TRUE) or not-genotyped (FALSE); default: NULL (all individuals)}

\item{npheno}{Only include individuals with the certain number of phenotypes generated (default: NULL (all individuals))}

\item{verbose}{Set to FALSE to not display any prints}

\item{sex.filter}{Set to 1 to only include males and set 2 to only include females in database (default: 0)}
}
\value{
Matrix with combined gen/database/cohorts
}
\description{
Function to derive a database based on gen/database/cohorts
}
\examples{
data(ex_pop)
get.database(ex_pop, gen=2)
}
