% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.base.generation.R
\name{new.base.generation}
\alias{new.base.generation}
\title{Set new base generation}
\usage{
new.base.generation(
  population,
  base.gen = NULL,
  base.database = NULL,
  base.cohorts = NULL,
  delete.previous.gen = FALSE,
  delete.breeding.totals = FALSE,
  delete.bve.data = FALSE,
  add.chromosome.ends = TRUE,
  founder.pool = 1
)
}
\arguments{
\item{population}{Population list}

\item{base.gen}{Vector containing all new base generations}

\item{base.database}{Matrix containing all database entries to be used as new base generation}

\item{base.cohorts}{Vector containing all cohorts to be used as new base generations}

\item{delete.previous.gen}{Delete all data before base.gen (default: FALSE)}

\item{delete.breeding.totals}{Delete all breeding totals before base.gen (default: FALSE)}

\item{delete.bve.data}{Delete all previous bve data (default: FALSE)}

\item{add.chromosome.ends}{Add chromosome ends as recombination points}

\item{founder.pool}{AAA}
}
\value{
Population-List with mutated marker for the selected individual
}
\description{
Function to set a new base generation for the population
}
\examples{
data(ex_pop)
ex_pop <- new.base.generation(ex_pop, base.gen=2)
}
