% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createNodeVariable}
\alias{createNodeVariable}
\alias{monadicCovar}
\title{createNodeVariable}
\usage{
createNodeVariable(
  values,
  range = NULL,
  nodeSet = NULL,
  nodes = NULL,
  edges = NULL,
  addSame = NULL,
  addSim = NULL
)

monadicCovar(
  values,
  range = NULL,
  nodeSet = NULL,
  nodes = NULL,
  edges = NULL,
  addSame = NULL,
  addSim = NULL
)
}
\arguments{
\item{values}{A vector assigning the covariate value to each element of the nodeset.}

\item{range}{The range of possible values, currently not in use.}

\item{nodeSet}{The nodeset to which the covariate applies.}

\item{nodes}{Alternative way to specify the nodeSet by naming nodes or edges:
nodes denote the locations in the edgelist}

\item{edges}{Alternative way to specify the nodeSet by naming nodes or edges:
edges denote the individuals in the edgelist}

\item{addSame}{Will the variable be used to model categorical homophily (e.g.,
with the same_covariate effect)? In this case, addSame needs to be set to TRUE.}

\item{addSim}{Will the variable be used to model continuous homophily (e.g.,
with the sim_covariate effect)? In this case, addSim needs to be set to TRUE.}
}
\value{
An object of class "nodeVar.monan".
}
\description{
Assigns a covariate to one nodeset, i.e., an exogenous characteristic of mobile
individuals/resources or locations.
}
\examples{
# create an object of class nodeVar.monan
region <- createNodeVariable(orgRegion, nodeSet = "organisations")
size <- createNodeVariable(orgSize, nodeSet = "organisations", addSim = TRUE)
sex <- createNodeVariable(indSex, nodeSet = "people")
}
\seealso{
\code{\link[=createProcessState]{createProcessState()}}
}
