% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoTBFClass.R
\name{summary.motbf}
\alias{summary.motbf}
\alias{print.summary.motbf}
\title{Summary of an \code{"motbf"} object}
\usage{
\method{summary}{motbf}(object, ...)

\method{print}{summary.motbf}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"motbf"}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object of class \code{"summary.motbf"}.}
}
\value{
The summary of an \code{"motbf"} object. It contains a list of
elements with the most important information of the object.
}
\description{
Summarize an \code{"motbf"} object by describing its main features.
}
\examples{
## Subclass 'MOP'
X <- rnorm(1000)
P <- univMoTBF(X, POTENTIAL_TYPE="MOP") ## or POTENTIAL_TYPE="MTE"
summary(P)
attributes(sP <- summary(P))
attributes(sP)
sP$Function
sP$Subclass
sP$Iterations

## Subclass 'MTE'
X <- rnorm(1000)
P <- univMoTBF(X, POTENTIAL_TYPE="MTE")
summary(P)
attributes(sP <- summary(P))
attributes(sP)
sP$Function
sP$Subclass
sP$Iterations
}
\seealso{
\link{univMoTBF}
}
