% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_model.r
\name{predict.ModelMatrixModel}
\alias{predict.ModelMatrixModel}
\title{predict() function}
\usage{
\method{predict}{ModelMatrixModel}(object, data, handleInvalid = "keep", verbose = FALSE, ...)
}
\arguments{
\item{object}{a ModelMatrixModel object.}

\item{data}{a data.frame.}

\item{handleInvalid}{a string,'keep' or 'error'.  In dummy variable transformation, if categorical variable has a factor level that is unseen before, 'keep' will keep the record, output dummy variables will be all zero.}

\item{verbose}{boolean, if print out progress.}

\item{...}{other parameters.}
}
\value{
A ModelMatrixModel class,which includes the transformed matrix and  the necessary transforming parameters copied from input object.
}
\description{
This function transforms new data based on transforming parameters from a ModelMatrixModel object
}
\examples{
library(ModelMatrixModel)
traindf= data.frame(x1 = sample(LETTERS[1:5], replace = TRUE, 20),
                    x2 = rnorm(20, 100, 5),
                    y = rnorm(20, 10, 2))
newdf=data.frame(x1 = sample(LETTERS[1:5], replace = TRUE, 3),
                 x2 = rnorm(3, 100, 5))
mm=ModelMatrixModel(~x1+x2,traindf,remove_1st_dummy = FALSE)
mm_pred=predict(mm,newdf)
data.frame(as.matrix(head(mm_pred$x,2)))
}
