% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submitModels.R
\name{get_job_status}
\alias{get_job_status}
\title{This function checks the status of one or more compute jobs}
\usage{
get_job_status(job_ids, scheduler = "slurm", quiet = TRUE)
}
\arguments{
\item{job_ids}{One or more job ids of existing PBS or slurm jobs, or process ids of a local process for
\code{scheduler="sh"}.}

\item{scheduler}{What scheduler is used for job execution.
Options: c("torque", "qsub", "slurm", "sbatch", "sh", "local")}

\item{quiet}{If \code{TRUE}, \code{wait_for_job} will not print out any status updates on jobs. If \code{FALSE},
the function prints out status updates for each tracked job so that the user knows what's holding up progress.}
}
\value{
A vector of job statuses corresponding to each job id
}
\description{
This function checks the status of one or more compute jobs
}
\details{
Note that for the \code{scheduler} argument, "torque" and "qsub" are the same;
"slurm" and "sbatch" are the same, and "sh" and "local" are the same.
}
\examples{
\dontrun{
# example on qsub/torque cluster
get_job_status("7968857.torque01.util.production.int.aci.ics.psu.edu", scheduler = "torque")

# example of checking two jobs on slurm cluster
get_job_status(c("24147864", "24147876"), scheduler = "slurm")

# example of checking two jobs on local machine
get_job_status(c("9843", "9844"), scheduler = "local")
}

}
\author{
Michael Hallquist
}
\keyword{internal}
