% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LGMobject.R
\name{LGMobject}
\alias{LGMobject}
\title{Create Mplus model objects for Latent Growth Modelling (LGM)}
\usage{
LGMobject(
  data,
  outvar,
  catvar = FALSE,
  idvar,
  k,
  starting_val,
  estimator = c("MLR", "ML", "WLSMV", "WLS"),
  transformation = c("LOGIT", "PROBIT"),
  lgm_type = c("gcm", "gbtm", "lcga_t", "lcga_c", "lcga_tc"),
  polynomial = 1,
  timescores,
  timescores_indiv = FALSE,
  output,
  plot,
  save
)
}
\arguments{
\item{data}{A data frame containing all variables for the trajectory analysis.}

\item{outvar}{A character vector specifying the outcome variables at different times.}

\item{catvar}{A logical value indicating whether the outcome variable is categorical. Default is \code{FALSE}.}

\item{idvar}{A character string specifying the ID variable.}

\item{k}{An integer specifying the number of latent classes for the model.}

\item{starting_val}{A numeric value specifying the number of random starting values to generate for the initial optimization stage.
Note that the number of final stage optimizations will be set as equal to half of this value.}

\item{estimator}{A character string to specify the estimator to use in the analysis. Default is 'MLR'.}

\item{transformation}{A character string to specify the latent response variable transformation to use when the outcome variable is categorical. Default is \code{LOGIT}.}

\item{lgm_type}{A character string specifying the residual variance structure of the growth model. Options include:
\itemize{
\item - "gcm" (relaxed residual variance across time),
\item - "gbtm" (fixed residual variance across time and class),
\item - "lcga_t" (relaxed residual variance across time),
\item - "lcga_c" (relaxed residual variance across class),
\item - "lcga_tc" (relaxed residual variance across both time and class).
}}

\item{polynomial}{An integer specifying the order of the polynomial used to model trajectories. Supported values are:
1 (linear), 2 (quadratic), 3 (cubic). Default is 1.}

\item{timescores}{A numeric vector specifying the time scores for the model. If \code{timescores_indiv = TRUE},
a character vector should be used to specify variables with individually varying times of observation.}

\item{timescores_indiv}{A logical value indicating whether to use individually varying times of observation for the outcome variable. Default is \code{FALSE}.}

\item{output}{A character vector specifying the requested Mplus output options for the model.}

\item{plot}{A character string specifying the requested Mplus plot options for the model.}

\item{save}{A character string specifying the type of results to be saved by Mplus.}
}
\value{
A list of class \code{mplusObject} with elements specifying sections of an Mplus input file for conducting latent growth modeling.
}
\description{
Provide flexibility for specifying Mplus LGM objects with various latent class and residual variance structures, and capturing individual differences in growth trajectories.
Support Growth Curve Models (GCM), Growth-Based Trajectory Models (GBTM) and Latent Class Growth Analysis (LCGA).
Once created, the model can be estimated using the \code{runLGM} function.
}
\details{
The \code{LGMobject} function facilitates and automates the appropriate model specification for conducting latent growth modeling in Mplus.
It creates the relevant sections of an Mplus input file, including: TITLE, VARIABLE, ANALYSIS, MODEL, OUTPUT, PLOT, and SAVEDATA.

This function builds upon the capabilities of the \code{\link[MplusAutomation]{mplusObject}}function
from the MplusAutomation package.
}
\examples{
# Example usage:
GBTM_object <- LGMobject(
  data = symptoms,
  outvar = paste("sx", seq(from = 0, to = 24, by = 6), sep = "_"),
  idvar = "id",
  catvar = FALSE,
  k = 3L,
  starting_val = 500,
  lgm_type = "gbtm",
  polynomial = 3,
  timescores = seq(from = 0, to = 24, by = 6),
  timescores_indiv = FALSE,
  output = c("TECH1", "TECH14", "SAMPSTAT", "STANDARDIZED"),
  plot = "PLOT3",
  save = "FSCORES"
  )
}
\seealso{
\code{\link[MplusAutomation]{mplusObject}} for creating an mplusObject.
\code{\link{runLGM}} for conducting latent growth modelling with an mplusObject.
}
