% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphical.r
\name{graphical}
\alias{graphical}
\title{Graphical procedure}
\usage{
graphical(
  p = c(0.01, 0.04, 0.03),
  W = c(0.5, 0.25, 0.25),
  G = rbind(c(0, 1, 0), c(0, 0, 1), c(1, 0, 0)),
  alpha = 0.05
)
}
\arguments{
\item{p}{Numeric vector of p-values for the hypotheses.}

\item{W}{Numeric vector of weigths of the graph. Must have the same length
as \code{p}.}

\item{G}{Matrix of the transition matrix of the graph.}

\item{alpha}{Numeric scalar with the overall type-1 error rate.}
}
\value{
A list with a single element containing a vector indicating whether
hypotheses are rejected (\code{1}) or not (\code{0}).
}
\description{
\code{graphical()} performs graphical procedure to test multiple hypotheses
}
\examples{
graphical(p = c(0.02, 0.03, 0.01))
}
\author{
Kaiyuan Hua, Xiaodong Luo
}
\concept{graphical procedure}
\concept{multiple comparison}
