% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{get_balance_table}
\alias{get_balance_table}
\title{Generate balance table}
\usage{
get_balance_table(
  matching_result,
  cov_list = NULL,
  display_all = TRUE,
  stat_list = c("mean.diffs")
)
}
\arguments{
\item{matching_result}{an object returned by the main matching function
dist_bal_match}

\item{cov_list}{(optional) a vector of names of covariates used for evaluating
covariate imbalance; NULL by default.}

\item{display_all}{(optional) a boolean value indicating whether or not to
show the data for all possible matches; TRUE by default}

\item{stat_list}{(optional) a vector of statistics that are calculated for
evaluating the covariate imbalance between treated and control group. The
types that are supported can be found here: \link[cobalt]{bal.tab}.}
}
\value{
a named list object containing covariate balance table and statistics
for numer of units being matched for each match; the names are the
character of index for each match in the \code{matchResult}.
}
\description{
The helper function can generate tabular analytics that quantify
covariate imbalance after matching. It only works for the 'Basic' version of
matching (produced by \code{dist_bal_match}).
}
\details{
The result can be either directly used by indexing into the list, or
post-processing by the function \code{compare_tables} that summarizes the
covariate balance information in a tidier table. Users can specify the
arguments as follows: * \code{cov_list}: if it is set of NULL, all the covariates
are included for the covariate balance table; otherwise, only the specified
covariates will be included in the tabular result. * \code{display_all}: by
default, the summary statistics for each match are included when the
argument is set to TRUE. If the user only wants to see the summary
statistics for matches with varying performance on three different
objective values, the function would only display the matches with number
of treated units being excluded at different quantiles. User can switch to
the brief version by setting the parameter to FALSE. * \code{stat_list} is the
list of statistics used for measuring balance. The argument is the same as
\code{stats} argument in \link[cobalt]{bal.tab}, which is the function that is
used for calculating the statistics. By default, only standardized
difference in means is calculated.
}
\examples{
## Generate matches
data("lalonde", package="cobalt")
ps_cols <- c("age", "educ", "married", "nodegree", "race")
treat_val <- "treat"
response_val <- "re78"  
pair_dist_val <- c("age", "married", "educ", "nodegree", "race")
my_bal_val <- c("race")
r1s <- c(0.01,1,2,4,4.4,5.2,5.4,5.6,5.8,6)
r2s <- c(0.001)
match_result <- dist_bal_match(data=lalonde, treat_col= treat_val, 
marg_bal_col = my_bal_val, exclusion_penalty=r1s, balance_penalty=r2s, 
dist_col = pair_dist_val, 
propensity_col = ps_cols, max_iter=0)

## Generate summary table for balance 
balance_tables <- get_balance_table(match_result)
balance_tables_10 <- balance_tables$'10'
}
\seealso{
Other numerical analysis helper functions: 
\code{\link{generateRhoObj}()},
\code{\link{get_rho_obj}()},
\code{\link{get_unmatched}()}
}
\concept{numerical analysis helper functions}
