% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{QplicMatr}
\alias{QplicMatr}
\title{Qplication Matrix}
\usage{
QplicMatr(d, q, useSparse = FALSE)
}
\arguments{
\item{d}{dimension of a vector x}

\item{q}{power of the Kronecker product}

\item{useSparse}{TRUE or FALSE.}
}
\value{
Qplication matrix of order \eqn{d^q \times \eta_{d,q}}, see (1.30), p.15.
If \code{useSparse=TRUE} an object of the class "dgCMatrix" is produced.
}
\description{
Restores the duplicated/q-plicated  elements which are eliminated
by  EliminMatr in a T-product of vectors of dimension d.
}
\details{
Note: since the algorithm of elimination is not unique, q-plication works together
with the function  EliminMatr only.
}
\examples{
x<-c(1,2,3)
y<-kronecker(kronecker(x,x),x)
## Distinct elements of y
z<-as.matrix(EliminMatr(3,3))\%*\%y
## Restore eliminated elements in z
as.vector(QplicMatr(3,3)\%*\%z)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, p.21, (1.31)
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminIndx}()},
\code{\link{EliminMatr}()},
\code{\link{QplicIndx}()},
\code{\link{SymIndx}()},
\code{\link{SymMatr}()},
\code{\link{UnivMomCum}()}
}
\concept{Matrices and commutators}
