% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{SampleKurt}
\alias{SampleKurt}
\title{Estimation of Sample Kurtosis (Mardia, MRSz, Total)}
\usage{
SampleKurt(x, Type = c("Mardia", "MRSz", "Total"))
}
\arguments{
\item{x}{A matrix of multivariate data.}

\item{Type}{A character string specifying the type of kurtosis index to estimate. Use "Mardia" for Mardia's kurtosis index, "MRSz" for the Mori-Rohatgi-Szekely kurtosis matrix, or "Total" for the total kurtosis index.}
}
\value{
A list containing the estimated kurtosis index or matrix and the associated p-value under the Gaussian hypothesis.
\item{Mardia.Kurtosis}{The kurtosis index when \code{Type} is "Mardia".}
\item{MRSz.Kurtosis}{The kurtosis matrix when \code{Type} is "MRSz".}
\item{Total.Kurtosis}{The total kurtosis index when \code{Type} is "Total".}
\item{p.value}{The p-value under the Gaussian hypothesis for the estimated kurtosis.}
}
\description{
Estimates the sample kurtosis index based on the specified method: Mardia, MRSz, or Total.
}
\examples{
# Mardia's kurtosis example
x <- matrix(rnorm(100*5), ncol=5)
SampleKurt(x, Type = "Mardia")

# MRSz's kurtosis example
SampleKurt(x, Type = "MRSz")

# Total kurtosis example
SampleKurt(x, Type = "Total")

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear, Springer 2021. Example 6.1 and 6.9.
}
\seealso{
Other Estimation: 
\code{\link{SampleEVSK}()},
\code{\link{SampleMomCum}()},
\code{\link{SampleSkew}()},
\code{\link{VarianceKurt}()},
\code{\link{VarianceSkew}()}
}
\concept{Estimation}
