% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitModel.R
\name{FitModel}
\alias{FitModel}
\title{Funcao para ajusta modelos de regressoes multiplas}
\usage{
FitModel(X,Y,Rep=NULL,Model,Design=1)
}
\arguments{
\item{X}{Matriz contendo em cada coluna as variaveis explicativas, ou um
vetor contendo os nomes das variaveis explicativas.}

\item{Y}{Vetor contendo a variavel resposta.}

\item{Rep}{Vetor contendo a identificacao das repeticoes/blocos se o experimento
tiver delineamento estatistico.}

\item{Model}{Modelo de regressal a ser ajustado (do tipo formula).}

\item{Design}{Indica o delineamento do experimento, pode ser:
  \itemize{
\item design 1 -> Experimento  sem repeticao.
\item design 2 -> Experimento no delineamento inteiramente casualizado (DIC).
\item design 3 -> Experimento no delineamento em blocos casualizados (DBC).
  }}
}
\value{
A funcao retorna a anova, significancia de coeficientes e avaliadores
da qualidade do ajuste do modelo regressao.
}
\description{
Esta funcao ajusta modelos de regressao multipla e estima estatisticas importantes.
}
\examples{
data("DadosPalma")
X=DadosPalma[,-7]
Y=DadosPalma[,7]
model=CreateModel(X,Intercept = TRUE, Simple =TRUE, InteractionLL = TRUE)
model
Ajust=FitModel(X,Y,Model=model)
Ajust

}
\references{
Tutoriais onlines:
https://www.youtube.com/channel/UCDGyvLCJnv9RtTY1YMBMVNQ
}
\seealso{
\code{\link{lm}}, \code{\link{CreateModel}}, \code{\link{FitModel}}
}
