% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_split_improvement.R
\name{MeanSplitImprovement}
\alias{MeanSplitImprovement}
\title{Mean Split Improvement Importance Function}
\usage{
MeanSplitImprovement(
  X,
  Y,
  sample_size = trunc(nrow(X) * 0.8),
  num_trees = 100,
  m_feature = ncol(X),
  min_leaf = 10,
  alpha_threshold = 0
)
}
\arguments{
\item{X}{Feature matrix}

\item{Y}{Target matrix}

\item{sample_size}{Size of random subset for each tree generation}

\item{num_trees}{Number of Trees to generate}

\item{m_feature}{Number of randomly selected features considered for a split in each regression tree node, which
must be positive integer and less than N (number of input features)}

\item{min_leaf}{Minimum number of samples in the leaf node. If a node has less than or equal
to min_leaf samples, then there will be no splitting in that node and this node
will be considered as a leaf node. Valid input is positive integer, which is less
than or equal to M (number of training samples)}

\item{alpha_threshold}{threshold for split significant testing. If default value of 0 is specified,
all the node splits will contribute to result, otherwise only those splits with improvement greater
than 1-alpha critical value of an f-statistic do.}
}
\value{
Vector of size N x 1
}
\description{
Mean Split Improvement Importance Function
}
\details{
The mean split improvement importance function follows directly from Segal (1992) definition of the
mean structure based split function. For each split defined by feature j, it calculates the difference between the within
parent node sum of squares and the within children-nodes (left and right nodes) measured on either training or testing samples.
If feature j is used in splitting M nodes of the tree, the resulting tree-specific importance measure is the sum of the
node-specific differences calculated across all M nodes. The mean split improvement measure for feature j for the multivariate
random forest is the average of the tree-specific measures across all trees in the forest.

If the alpha threshold is 0 all the splits defined by feature j will be used in computing the importance measure. The user also has
the option of including only the significant node splits defined by feature j in the calculation of the importance measure.  The
significance of node splits is measured using an F-test. In this case, the user will need to threshold the alpha critical value of
the F-statistic based on the number of outcome variables in the target matrix and the number of left and right node samples
for the given node split.

Segal MR (1992) Tree-structured methods for longitudinal data. J. American Stat. Assoc. 87(418), 407-418.
}
\examples{
X = matrix(runif(50*5), 50, 5)
Y = matrix(runif(50*2), 50, 2)
MeanSplitImprovement(X, Y)
}
