% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStandings.R
\name{getStandings}
\alias{getStandings}
\title{Standing Data}
\usage{
getStandings(year, conf = c("East", "West", "All"))
}
\arguments{
\item{year}{Season number consisting 4 digits}

\item{conf}{Conference to fetch information for. Valid values are East, West or All}
}
\value{
This function returns \code{data.fram} including columns:
\itemize{
  \item Team
  \item W
  \item L
  \item Per
  \item GB
  \item PW
  \item PL
  \item PSG
  \item PAG
}
}
\description{
Standing data
}
\examples{
\dontrun{
  Standings06 <- getStandings(year = 2006, conf = "All")
  head(Standings06)
}

}
\seealso{
\url{https://www.basketball-reference.com/leagues/NBA_2019_standings.html}
}
\author{
Koki Ando <koki.25.ando@gmail.com>
}
