% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{getStatsPerGame}
\alias{getStatsPerGame}
\title{Stats Per Game for a given player}
\usage{
getStatsPerGame(player, season, span = 1)
}
\arguments{
\item{player}{Player name to fetch information for}

\item{season}{Season number}

\item{span}{Duration of season(s). Defaults 1.}
}
\value{
This function returns \code{data.frame} including columns:
\itemize{
 \item G
 \item Date
 \item Age
 \item Tm
 \item Home
 \item Opp
 \item GS
 \item MP
 \item FG
 \item FGA
 \item FGP
 \item 3PM
 \item 3PA
 \item 3PP
 \item FT
 \item FTA
 \item FTP
 \item ORB
 \item DRB
 \item TRB
 \item AST
 \item STL
 \item BLK
 \item TOV
 \item PF
 \item PTS
 \item GmSc
}
}
\description{
Function for getting given player's stats per game
}
\examples{
\dontrun{
RayAllen <- getStatsPerGame(player="Ray Allen", season=2008, span=1)
head(RayAllen)
}

}
\author{
Koki Ando <koki.25.ando@gmail.com>
}
