% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_methods.R
\name{show}
\alias{show}
\alias{show.nblda}
\alias{show,nblda-method}
\alias{show.nblda_trained}
\alias{show,nblda_trained-method}
\alias{show.nblda_input}
\alias{show,nblda_input-method}
\title{Show Method for the S4 classes in NBLDA Package}
\usage{
\method{show}{nblda}(object)

\S4method{show}{nblda}(object)

\method{show}{nblda_trained}(object)

\S4method{show}{nblda_trained}(object)

\method{show}{nblda_input}(object)

\S4method{show}{nblda_input}(object)
}
\arguments{
\item{object}{an object of class \code{nblda, nblda_trained} and \code{nblda_input} to be printed.}
}
\description{
Pretty print the objects in S4 classes on R console.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5, DE = 0.8,
                            allZero.rm = FALSE, tag.samples = TRUE)
x <- t(counts$x + 1)
y <- counts$y
xte <- t(counts$xte + 1)
ctrl <- nbldaControl(folds = 2, repeats = 2)

fit <- trainNBLDA(x = x, y = y, type = "mle", tuneLength = 10,
                  metric = "accuracy", train.control = ctrl)

show(fit)
show(inputs(fit))
show(nbldaTrained(fit))

}
\author{
Dincer Goksuluk
}
