% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{check.linux.install}
\alias{check.linux.install}
\title{Check whether a given system command is installed (e.g, bash)}
\usage{
check.linux.install(cmd = c("plink", "perl", "sed"), linux.mode = FALSE)
}
\arguments{
\item{cmd}{character vector of commands to test}

\item{linux.mode}{logical, alternate way of command testing that only works on linux and
mac OS X, to turn this on, set to TRUE.}
}
\value{
returns true or false for each command in 'cmd'
}
\description{
Tests whether a command is installed and callable by system().
Will return a warning if run on windows when linux.more=TRUE
}
\examples{
check.linux.install("R") # should be standard
check.linux.install(c("perl","sed","fake-cmd"))
}
\author{
Nicholas Cooper \email{njcooper@gmx.co.uk}
}
