% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NFCP-package.R
\docType{package}
\name{NFCP-package}
\alias{NFCP}
\alias{NFCP-package}
\title{NFCP: N-Factor Commodity Pricing Through Term Structure Estimation}
\description{
Commodity pricing models are (systems of) stochastic differential equations that are utilized for the valuation and hedging of commodity contingent claims (i.e. derivative products on the commodity) and other commodity related investments. Commodity pricing models that capture market dynamics are of great importance to commodity market participants in order to exercise sound investment and risk-management strategies. Parameters of commodity pricing models are estimated through maximum likelihood estimation, using available term structure futures data of a commodity. 'NFCP' (n-factor commodity pricing) provides a framework for the modeling, parameter estimation, probabilistic forecasting, option valuation and simulation of commodity prices through state space and Monte Carlo methods, risk-neutral valuation and Kalman filtering. 'NFCP' allows the commodity pricing model to consist of n correlated factors, with both random walk and mean-reverting elements. The n-factor commodity pricing model framework was first presented in the work of Cortazar and Naranjo (2006) \doi{10.1002/fut.20198}. Examples presented in 'NFCP' replicate the two-factor crude oil commodity pricing model presented in the prolific work of Schwartz and Smith (2000) \doi{10.1287/mnsc.46.7.893.12034} with the approximate term structure futures data applied within this study provided in the 'NFCP' package.
}
\author{
\strong{Maintainer}: Thomas Aspinall \email{tomaspinall2512@gmail.com} (\href{https://orcid.org/0000-0002-6968-1989}{ORCID})

Authors:
\itemize{
  \item Adrian Gepp \email{adgepp@bond.edu.au} (\href{https://orcid.org/0000-0003-1666-5501}{ORCID})
  \item Geoff Harris \email{gharris@bond.edu.au} (\href{https://orcid.org/0000-0003-4284-8619}{ORCID})
  \item Simone Kelly \email{skelly@bond.edu.au} (\href{https://orcid.org/0000-0002-6528-8557}{ORCID})
  \item Colette Southam \email{csoutham@bond.edu.au} (\href{https://orcid.org/0000-0001-7263-2347}{ORCID})
  \item Bruce Vanstone \email{bvanston@bond.edu.au} (\href{https://orcid.org/0000-0002-3977-2468}{ORCID})
}

}
\keyword{internal}
