% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{removeSelection}
\alias{removeSelection}
\title{Remove a selection}
\usage{
removeSelection(NGLVieweR_proxy, name)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{name}{Name of selection to be removed.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message
parameters.
}
\description{
Remove an existing NGLVieweR selection in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
     removeSelection("sel1")
}

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    titlePanel("Viewer with API inputs"),
    sidebarLayout(
      sidebarPanel(
        textInput("selection", "Selection", "1-20"),
        selectInput("type", "Type", c("ball+stick", "cartoon", "backbone")),
        selectInput("color", "Color", c("orange", "grey", "white")),
        actionButton("add", "Add"),
        actionButton("remove", "Remove")
      ),
      mainPanel(
        NGLVieweROutput("structure")
      )
    )
  )
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon",
          param = list(name = "cartoon", colorScheme = "residueindex")
        )
    })
    observeEvent(input$add, {
      NGLVieweR_proxy("structure") \%>\%
        addSelection(isolate(input$type),
          param =
            list(
              name = "sel1",
              sele = isolate(input$selection),
              colorValue = isolate(input$color)
            )
        )
    })

    observeEvent(input$remove, {
      NGLVieweR_proxy("structure") \%>\%
        removeSelection("sel1")
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "removeSelection".
}

Other selections: 
\code{\link{addSelection}()},
\code{\link{updateSelection}()}
}
\concept{selections}
