% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{zoomMove}
\alias{zoomMove}
\title{Set zoomMove}
\usage{
zoomMove(NGLVieweR, center, zoom, duration = 0, z_offSet = 0)
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{center}{Target distance of selected atoms/residues. See the section
"selection-language" in the official \href{https://nglviewer.org/}{NGL.js}
manual.}

\item{zoom}{Target zoom of selected atoms/residues. See the section
"selection-language" in the official \href{https://nglviewer.org/}{NGL.js}
manual.}

\item{duration}{Optional animation time in milliseconds (default = 0).}

\item{z_offSet}{Optional zoom offset value (default = 0).}
}
\value{
List of zoomMove parameters to \code{NGLVieweR} \code{htmlwidgets}
object.
}
\description{
Add a zoom animation
}
\examples{
NGLVieweR("7CID") \%>\%
stageParameters(backgroundColor = "white") \%>\%
  addRepresentation("cartoon", param=list(name="cartoon", colorValue="red")) \%>\%
  addRepresentation("ball+stick", param=list(name="ball+stick",
                                             colorValue="yellow",
                                             colorScheme="element",
                                             sele="200")) \%>\%
  zoomMove("200:A.C", "200:A.C", 2000, -20)
}
\seealso{
\itemize{
\item \code{\link[=setScale]{setScale()}}
\item \code{\link[=setRotation]{setRotation()}}
\item \code{\link[=setPosition]{setPosition()}}
}

Other transformations: 
\code{\link{setPosition}()},
\code{\link{setRotation}()},
\code{\link{setScale}()}
}
\concept{transformations}
