#' Stranded Patient (Patients flagged as having a greater than 7 day LOS) Model
#'
#' This model is to be used as a machine learning classification model, for supervised learning. The binary outcome is stranded vs not stranded patients.
#'
#'
#' @docType data
#'
#' @keywords datasets stranded_model
#'
#' @format Tibble with nine columns (1 x outcome and 8 predictors)
#' \describe{
#' \item{stranded.label}{Outcome variable - whether the patient is stranded or not}
#' \item{age}{Patient age on admission}
#' \item{care.home.referral}{Whether than have been referred from a care home}
#' \item{medicallysafe}{Medically safe for discharge - means the patient is assessed as safe, but has not been discharged yet}
#' \item{hcop}{Indicates whether they have been triaged from a Health Care for Older People specialty}
#' \item{mental_health_care}{Flag to indicate whether they need mental health support and care}
#' \item{periods_of_previous_care}{Count of the number of previous spells of care}
#' \item{admit_date}{Date they were admitted to hospital}
#' \item{frailty_index}{An initial index assessment to say if the patient is frail or not. This is needed for alignment of service provision.}
#' }
#'
#' @source Synthetically generated by Gary Hutson \email{g.hutson@nhs.net}, Mar-2021.
#'
#' @usage data(stranded_data)
#'
#' @examples
#' library(magrittr)
#' library(dplyr)
#' data("stranded_data")
#' stranded_data %>%
#'  glimpse()
#'
"stranded_data"
