% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{StanfordCoreNLP_Pipeline}
\alias{StanfordCoreNLP_Pipeline}
\title{Stanford \code{CoreNLP} annotator pipeline}
\usage{
StanfordCoreNLP_Pipeline(annotators = c("pos", "lemma"),
  language = "en", control = list(), port = 9000L,
  host = "localhost")
}
\arguments{
\item{annotators}{a character string specifying the annotators to be used in addition
to \sQuote{ssplit} (sentence token annotation) and \sQuote{tokenize}
(word token annotations), with elements
\code{"pos"} (POS tagging),
\code{"lemma"} (lemmatizing),
\code{"ner"} (named entity recognition),
\code{"regexner"} (rule-based named entity recognition over token
sequences using Java regular expressions),
\code{"parse"} (constituency parsing),
\code{"depparse"} (dependency parsing),
\code{"sentiment"} (sentiment analysis),
\code{"coref"} (coference resolution),
\code{"dcoref"} (deterministic coference resolution),
\code{"cleanxml"} (clean XML tags),
or
\code{"relation"} (relation extraction),
or unique abbreviations thereof.
Ignored for languages other than English.}

\item{language}{a character string giving the ISO-639 code of the
language being processed by the annotator pipeline.}

\item{control}{a named or empty (default) list vector with annotator control
options, with the names giving the option names.  See
\url{https://stanfordnlp.github.io/CoreNLP/annotators.html} for
available control options.}

\item{port}{an integer giving the port (default is \code{9000L}).}

\item{host}{a character string giving the hostname of the server.}
}
\value{
An \code{\link[NLP]{Annotator}} object providing the annotator pipeline.
}
\description{
Create a Stanford \code{CoreNLP} annotator pipeline.
}
\note{
See \url{https://stanfordnlp.github.io/CoreNLP/#citing-stanford-corenlp-in-papers}
  for information on citing Stanford CoreNLP.

  Using the parse annotator requires considerable amounts of (Java)
  memory.  The Stanford CoreNLP documentation suggests starting the JVM
  with at least 3GB of memory on 64-bit systems (and in fact, not using
  32-bit systems), and hence have the JVM started with \option{-Xmx3g}
  unless option \code{java.parameters} is set to something non-empty
  (hence, this option should be set appropriately to accommodate
  different memory requirements or constraints).

  Using the coreference annotators nowadays requires even more (Java)
  memory.  The Stanford CoreNLP documentation suggests starting the JVM
  with at least 5GB of memory; we find 4GB sufficient.  Hence, to use
  these annotators one needs to set option \code{java.parameters} as
  appropriate before starting the JVM.
}
\examples{
require("NLP")
s <- as.String(paste("Stanford University is located in California.",
                     "It is a great university."))
s

## Annotators: ssplit, tokenize:
if ( ping_nlp_client() == "pong" ) {
p <- StanfordCoreNLP_Pipeline(NULL)
a <- p(s)
a

## Annotators: ssplit, tokenize, pos, lemma (default):
p <- StanfordCoreNLP_Pipeline()
a <- p(s)
a

## Equivalently:
annotate(s, p)

## Annotators: ssplit, tokenize, parse:
p <- StanfordCoreNLP_Pipeline("parse")
a <- p(s)
a

## Respective formatted parse trees using Penn Treebank notation
## (see <https://catalog.ldc.upenn.edu/docs/LDC95T7/cl93.html>):
ptexts <- sapply(subset(a, type == "sentence")$features, `[[`, "parse")
ptexts

## Read into NLP Tree objects.
ptrees <- lapply(ptexts, Tree_parse)
ptrees

## Basic dependencies:
depends <- lapply(subset(a, type == "sentence")$features, `[[`,
                  "basic-dependencies")
depends
## Note that the non-zero ids (gid for governor and did for dependent)
## refer to word token positions within the respective sentences, and
## not the ids of these token in the annotation: these can easily be
## matched using the sentence constituents features:
lapply(subset(a, type == "sentence")$features, `[[`, "constituents")

## (Similarly for sentence ids used in dcoref document features.)

## Note also that the dependencies are returned as a data frame 
## inheriting from class "Stanford_typed_dependencies" which has print
## and format methods for obtaining the usual formatting.
depends[[1L]]
## Use as.data.frame() to obtain strip this class:
as.data.frame(depends[[1L]])
}
}
\seealso{
\url{https://stanfordnlp.github.io/CoreNLP/} for more 
  information about the Stanford CoreNLP tools.
}
