% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoTest.nm.R
\name{IsoTest.nm}
\alias{IsoTest.nm}
\title{Calculate the value of the test statistics for testing monotonic trend}
\usage{
IsoTest.nm(data.nm, dose, response, stat=c("E2", "Williams","Marcus",
  "M", "ModM"))
}
\arguments{
\item{data.nm}{Nanomaterial dataset}

\item{dose}{Dose or concentration (with the same unit of measurement)}

\item{response}{Response (a certain endpoint value)}

\item{stat}{Test statistics ("\code{E2}" for the global likelihood test,
"\code{Williams}" for Williams test, "\code{Marcus}" for Marcus test,
"\code{M}" for M test or "\code{ModM}" for modified M test)}
}
\value{
This function calculates the value of the specified test statistics
  for one nanomaterial
}
\description{
This function provides the value of the test statistics (the global
likelihood test, Williams, Marcus, M or modified M test) for one nanomaterial
}
\details{
This function is intended to be used inside the function
  \code{\link{Isotest}}. However, it can also be used to obtain the value of
  a specified test statistics for one nanomaterial, with a particular unit of
  measurement of the dose, for a certain toxicity endpoint.
}
\examples{
#nm400 contains the result of genetic toxicity in vitro study of NM-400
#(Multi-walled carbon nanotubes) with associated controls
IsoTest.nm(data.nm=nm400, dose="concentration", response="value", stat="E2")
}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
\seealso{
\code{\link{Isotest}}
}
