% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNPC.R
\name{GNPC}
\alias{GNPC}
\title{Estimation of examinees' attribute profiles using the GNPC method}
\usage{
GNPC(
  Y,
  Q,
  initial.dis = c("hamming", "whamming"),
  initial.gate = c("AND", "OR", "Mix")
)
}
\arguments{
\item{Y}{A \eqn{N \times J} binary data matrix consisting of the responses
from \eqn{N} examinees to \eqn{J} items.}

\item{Q}{A \eqn{J \times K} binary Q-matrix where the entry \eqn{q_{jk}}
describing whether the \eqn{k}th attribute is required by the \eqn{j}th item.}

\item{initial.dis}{The type of distance used in the \code{AlphaNP} to carry
out the initial attribute profiles for the GNPC method.
Allowable options are \code{"hamming"} and \code{"whamming"} representing
the Hamming and the weighted Hamming distances, respectively.}

\item{initial.gate}{The type of relation between examinees' attribute profiles
and the items.
Allowable relations are \code{"AND"}, \code{"OR"}, and \code{"Mix"},
representing the conjunctive, disjunctive, and mixed relations, respectively}
}
\value{
The function returns a series of outputs, including
\describe{
\item{att.est}{The estimates of examinees' attribute profiles}
\item{class}{The estimates of examinees' class memberships}
\item{weighted.ideal}{The weighted ideal responses}
\item{weight}{The weights used to compute the weighted ideal responses}
}
}
\description{
Function \code{GNPC} is used to estimate examinees' attribute profiles using
the general nonparametric classification (GNPC) method
(Chiu, Sun, & Bian, 2018; Chiu & Koehn, 2019). It can be
used with data conforming to any CDMs.
}
\section{GNPC algorithm}{

A weighted ideal response \eqn{\eta^{(w)}}, defined as the convex combination
of \eqn{\eta^(c)} and \eqn{\eta^(d)}, is proposed.
Suppose item j requires \eqn{K_{j}^* \leq {K}} attributes that, without loss of
generality, have been permuted to the first \eqn{K_{j}^*} positions of the item
attribute vector \eqn{\boldsymbol{q_j}}. For each item j and \eqn{\mathcal{C}_{l}},
the weighted ideal response \eqn{\eta_{ij}^{(w)}} is defined as the convex combination
\eqn{\eta_{ij}^{(w)} = w _{lj} \eta_{lj}^{(c)}+(1-w_{lj})\eta_{lj}^{(d)}}
where \eqn{0\leq w_{lj}\leq 1}. The distance between the observed responses
to item j and the weighted ideal responses \eqn{w_{lj}^{(w)}} of examinees
in \eqn{\mathcal{C}_{l}} is defined as the sum of squared deviations:
\eqn{d_{lj} = \sum_{i \in \mathcal {C}_{l}} (y_{ij} - \eta_{lj}^{(w)})^2=\sum_{i \in \mathcal {C}_{l}}(y_{ij}-w_{lj}\eta_{lj}^{(c)}-(1-w_{lj})\eta_{lj}^{(d)})}
Thus, \eqn{\widehat{w_{lj}}} can be minimizing \eqn{d_{lj}}:
\eqn{\widehat{w_{lj}}=\frac{\sum_{i \in \mathcal {C}_{l}}(y_{ij}-\eta_{lj}^{(d)})}{\left \| \mathcal{C}_{l} \right \|(\eta_{lj}^{(c)}-\eta_{lj}^{(d)})}}

As a viable alternative to \eqn{\boldsymbol{\eta^{(c)}}} for obtaining initial
estimates of the proficiency classes, Chiu et al. (2018) suggested to
use an ideal response with fixed weights defined as
\eqn{\eta_{lj}^{(fw)}=\frac{\sum_{k=1}^{K}\alpha_{k}q_{jk}}{K}\eta_{lj}^{(c)}+(1-\frac{\sum_{k=1}^{K}\alpha_{k}q_{jk}}{K})\eta_{lj}^{(d)}}
}

